﻿using NAudio.Dsp;
using NAudio.Wave;
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace Spectral1.SPECTRUM_ANALYSER
{
    public partial class PL_Spectrum_Analyser : Form
    {
        #region "============================= DECLARATIONS ============================"
        private PL_Main _plm;
        private WaveOut waveOut;
        private c_spectrum_analyser sa;
        WaveChannel32 wc32;

        #endregion

        #region "============================= PROPERTIES =============================="

        public List<int> result_timbre_harmonics
        {
            get
            {
                if (sa != null)
                { return sa.result_timbre_harmonics; }
                else
                { return null; }
            }
        }

        #endregion

        #region "============================= EVENTS =================================="
        private void button_ok_Click(object sender, EventArgs e)
        {
            this.DialogResult = DialogResult.OK;
            this.Close();
        }

        private void button_cancel_Click_1(object sender, EventArgs e)
        {
            this.DialogResult = DialogResult.Cancel;  
            this.Close();
        }

        private void PL_Spectrum_Analyser_FormClosing(object sender, FormClosingEventArgs e)
        {
            stop_playback();
        }

        private void button_play_Click(object sender, EventArgs e)
        {
            button_play.Text = "Stop";
            OpenFile(textBox_file_path.Text);
        }

        private void button_select_file_Click(object sender, EventArgs e)
        {
            stop_playback();
            using (System.Windows.Forms.OpenFileDialog openFileDialog1 = new System.Windows.Forms.OpenFileDialog())
            {
                try
                {
                    if (Properties.Settings.Default.last_opened_filepath != null && Properties.Settings.Default.last_opened_filepath != "")
                    {
                        openFileDialog1.InitialDirectory = Path.GetFullPath(Properties.Settings.Default.last_opened_filepath);
                    }

                    openFileDialog1.RestoreDirectory = true;
                    openFileDialog1.Title = "Open WAV file";
                    openFileDialog1.DefaultExt = "wav";
                    openFileDialog1.Filter = "WAV files (*.wav)|*.wav";

                    if (openFileDialog1.ShowDialog() == DialogResult.OK)
                    {
                        textBox_file_path.Text = openFileDialog1.FileName;
                        RefreshUI();
                    }
                }
                catch (Exception ex)
                {
                    _plm.PLInfo.DisplayMinorError("Error opening file : " + ex.Message);
                }
            }
        }

        private void FftCalculated(object sender, FftEventArgs e)
        {
            if (sa != null)
            {
                bool display_low_freq_only = uC_spectrum_display2.display_low_freq_only;
                uC_signal_display1.Refresh();
                uC_spectrum_display2.refresh_spectrum_display(sa.get_spectrum_polyline(display_low_freq_only), sa.get_spectrum_ra_polyline(display_low_freq_only));
                uC_spectrum_analysis1.refresh_spectrum_analysis_polyline(sa.get_spectrum_analysis_polyline());
            } 
        }

        private void checkBox_loop_CheckedChanged(object sender, EventArgs e)
        {
            loop_check();
        }

        private void trackBar_volume_Scroll(object sender, EventArgs e)
        {
            set_volume();
        }
        #endregion

        #region "=============================== METHODS ============================"

        public PL_Spectrum_Analyser(PL_Main plm)
        {
            InitializeComponent();
            _plm = plm;
        }

        private void stop_playback()
        {
            if (waveOut != null)
            {
                waveOut.Stop();
                waveOut.Dispose();
                waveOut = null;
                button_play.Text = "Start";
            }
        }

        private void RefreshUI()
        { }

        private void OpenFile(string file_path)
        {
            if (waveOut == null)
            {
                try
                {
                    WaveFileReader reader = new WaveFileReader(file_path);
                    WaveFormat wf = new WaveFormat(c_spectrum_analyser.fft_sample_rate, 16, 1);
                    WaveFormatConversionStream wfcs = new WaveFormatConversionStream(wf, reader);
                    wc32 = new WaveChannel32(wfcs);
                    set_volume();
                    sa = new c_spectrum_analyser(wc32, uC_spectrum_display2.display_rectangle,uC_signal_display1.display_rectangle,uC_spectrum_analysis1.DisplayRectangle);
                    sa.FftCalculated += FftCalculated;
                    uC_signal_display1.initialise(sa.waveform_signal_display_buffer);
                    uC_spectrum_display2.initialise();
                    waveOut = new WaveOut();
                    waveOut.Init(sa);
                    waveOut.Play();
                    loop_check();
                }
                catch (Exception ex)
                {
                    _plm.PLInfo.DisplayMinorError("Error opening file : " + ex.Message);
                }
            }
            else
            {
                stop_playback();
            }
        }

        private void loop_check()
        {
            if (sa != null)
            {
                if (checkBox_loop.Checked == true)
                {
                    sa.start_loop((double)(numericUpDown_ls.Value));
                }
                else
                {
                    sa.stop_loop();
                }
            }
        }

        private void set_volume()
        {
            if (wc32 != null)
            {
                float v = (float)(trackBar_volume.Value) / (float)25.0;
                wc32.Volume = v;
            }
        }

        #endregion

    }
}
